
// Implementation of the NdInitReader class.
 

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cxx/logger.h>
extern "C" {
    #include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"


using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.NdInitReader"));

/**
 * Constructor. 
 */
NdInitReader::NdInitReader(void): 
  TechmodelAlgorithm(PacketType::NdInit, "TechmodelAcInitReader") { 
  logger->debug(_T("Constructor"));
  ndInit = new NdInitEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string NdInitReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/NdInitReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void NdInitReader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &ndInit, ndInit->Class());
}

/**
 * Unpack the AcInit event from an input file.
 */
void NdInitReader::RunEvent(int EventNumber, long int length) throw (WrongCRCException){
/*
    rec = new NeutronRecord(); //aggiungo un nuovo NeutronRecord all'evento
    rec->upperTrig   = (((BYTE)data[lenght-offset])>>4);
    rec->bottomTrig  = (((BYTE)data[lenght-offset])&0x0F);
    rec->upperBack   = (((BYTE)data[lenght-offset+1])>>4);
    rec->bottomBack  = (((BYTE)data[lenght-offset+1])&0x0F);    
 */  
}

