
// Implementation of the TestTrkReader class.
 

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cxx/logger.h>
extern "C" {
#include <sys/time.h>
#include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

#include "event/TestTrkEvent.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.TestTrkReader"));

/**
 * Constructor. 
 */
TestTrkReader::TestTrkReader(void): 
  TechmodelAlgorithm(PacketType::TestTrk, "TechmodelTestTrkReader") { 
  logger->debug(_T("Constructor"));
  testTrk = new TestTrkEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string TestTrkReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/TestTrkReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void TestTrkReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &testTrk, testTrk->Class());
  logger->debug(_T("Initialize"));
}

/**
 * Unpack the TestTrk event from an input file.
 */
void TestTrkReader::RunEvent(int EventNumber, long int length) {
    
    
}

