
// Implementation of the AcInitReader class.
 

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cpp/Category.hh>
extern "C" {
#include <sys/time.h>
#include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

#include "event/AcInitEvent.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cpp::Category& cat = log4cpp::Category::getInstance("pamela.techmodel.AcInitReader");  

/**
 * Constructor. 
 */
AcInitReader::AcInitReader(void): 
  TechmodelAlgorithm(PacketType::AcInit, "TechmodelAcInitReader") { 
  cat <<  log4cpp::Priority::DEBUG
      <<  "Constructor "
      <<  "\n " << log4cpp::CategoryStream::ENDLINE;
  acInit = new AcInitEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string AcInitReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/AcInitReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void AcInitReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &acInit, acInit->Class());
}

/**
 * Unpack the AcInit event from an input file.
 */
void AcInitReader::RunEvent(int EventNumber, long int length) {
    
    
}

