/** @file
 * $Source: /home/cvspamela/yoda/techmodel/ForcedPktReader.cpp,v $
 * $Id: ForcedPktReader.cpp,v 1.1 2004/06/09 23:18:20 nagni Exp $
 * $Author: nagni $
 * 
 * Implementation of the ForcedPkt class.
*/

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cpp/Category.hh>
extern "C" {
#include <sys/time.h>
#include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

#include "event/ForcedPktEvent.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cpp::Category& cat = log4cpp::Category::getInstance("pamela.techmodel.ForcedPktReader");  

/**
 * Constructor. 
 */
ForcedPktReader::ForcedPktReader(void): 
  TechmodelAlgorithm(PacketType::Log, "TechmodelForcedPktReader") { 
  cat <<  log4cpp::Priority::DEBUG
      <<  "Constructor "
      <<  "\n " << log4cpp::CategoryStream::ENDLINE;
  ForcedPkt = new ForcedPktEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string ForcedPktReader::GetVersionInfo(void) const {
  return 
    "$Header: /home/cvspamela/yoda/techmodel/ForcedPktReader.cpp,v 1.1 2004/06/09 23:18:20 nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void ForcedPktReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &ForcedPkt, ForcedPkt->Class());
}

/**
 * Unpack the ForcedPkt event from an input file.
 */
void ForcedPktReader::RunEvent(int EventNumber, long int length) {
    
}

