/** @file
 * $Source: /home/cvspamela/yoda/techmodel/CalibTrkReader.cpp,v $
 * $Id: CalibTrkReader.cpp,v 1.1 2004/05/11 10:12:35 nagni Exp $
 * $Author: nagni $
 * 
 * Implementation of the LogReader class.
* ToBeDone:
* Control the CRC for the entire data Packet not just for single records
 */

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cpp/Category.hh>
extern "C" {
    //The int* return the error code
    //The char* is the path to the temporary file
    extern void trkcalibpkt_(int*, char*); 

    //Struct per il passaggio di dati da e verso la chiamata fortran
    extern struct {
      int   DAQmode[6];
      int   DSPnumber[6];
      int   calibnumber[6];
      int   ncalib_event[6];
      int   ped_l1[6];
      int   ped_l2[6];
      int   ped_l3[6];
      int   sig_l1[6];
      int   sig_l2[6];
      int   sig_l3[6];
      int   nbad_l1[6];
      int   nbad_l2[6];
      int   nbad_l3[6];
      int   cal_flag[6];
      int   checksum[6];
      int   DSPbad_par[6][3072];
      float DSPped_par[6][3072];
      float DSPsig_par[6][3072];
    } trkcalib_;

#include <dirent.h>
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"
#include "event/PamelaRun.h"

#include "event/CalibTrkEvent.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cpp::Category& cat = log4cpp::Category::getInstance("pamela.techmodel.CalibTrkReader");  

/**
 * Constructor. 
 */
CalibTrkReader::CalibTrkReader(void): 
  TechmodelAlgorithm(PacketType::CalibTrk, "TechmodelCalibTrkReader") { 
  cat <<  log4cpp::Priority::DEBUG
      <<  "Constructor "
      <<  "\n " << log4cpp::CategoryStream::ENDLINE;
  calibTrk = new CalibTrkEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string CalibTrkReader::GetVersionInfo(void) const {
  return 
    "$Header: /home/cvspamela/yoda/techmodel/CalibTrkReader.cpp,v 1.1 2004/05/11 10:12:35 nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void CalibTrkReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &calibTrk, calibTrk->Class());
}

/**
 * Unpack the CalibTrk event from an input file.
 */
//void CalibTrkReader::RunEvent(int EventNumber, long int length, char *subData) {
void CalibTrkReader::RunEvent(int EventNumber, long int length) {
    int       ERROR;
    
    //the 2 bytes subtracted belong to the final event CRC bytes
    long int dataLength = length;// - (long int)2;

    char *subData = new char[dataLength];
    InputFile->read(subData, sizeof(unsigned char)*dataLength);

    //Skip the last two crc bytes already checked in UnpackPscu
    //This part have to be refactored!!!! too bad......
    InputFile->seekg((long int)2, std::ios::cur);

    //Scrivo un file temporaneo per passarlo alla routine
    //Speriamo di cambiare la routine per passargli un buffer.....
    DIR *dirp;
    std::string pathDir((char*)getenv("YODA_DATA"));
    pathDir = pathDir + "/";
    pathDir = pathDir + PamelaRun::GetRunName(EventNumber) + "/todatemp.dat";
    FILE *pfile;
    pfile = fopen((char*)pathDir.c_str(), "wb");
    fwrite(subData, 1, dataLength, pfile);
    fclose(pfile);

    //Call to the FORTRAN routin that unpack tracker events
    trkcalibpkt_(&ERROR, (char*)pathDir.c_str());
    
    remove((char*)pathDir.c_str());
    
    //Store the unpacked data
    memcpy(calibTrk->DAQmode,     trkcalib_.DAQmode,     sizeof(calibTrk->DAQmode));
    memcpy(calibTrk->DSPnumber,   trkcalib_.DSPnumber,   sizeof(calibTrk->DSPnumber));
    memcpy(calibTrk->calibnumber, trkcalib_.calibnumber, sizeof(calibTrk->calibnumber));
    memcpy(calibTrk->DSPnumber, trkcalib_.ncalib_event,  sizeof(calibTrk->ncalib_event));
    memcpy(calibTrk->ped_l1,    trkcalib_.ped_l1,     sizeof(calibTrk->ped_l1));
    memcpy(calibTrk->ped_l2,    trkcalib_.ped_l2,     sizeof(calibTrk->ped_l2));
    memcpy(calibTrk->ped_l3,    trkcalib_.ped_l3,     sizeof(calibTrk->ped_l3));
    memcpy(calibTrk->sig_l1,    trkcalib_.sig_l1,     sizeof(calibTrk->sig_l1));
    memcpy(calibTrk->sig_l2,    trkcalib_.sig_l2,     sizeof(calibTrk->sig_l2));
    memcpy(calibTrk->sig_l3,    trkcalib_.sig_l3,     sizeof(calibTrk->sig_l3));
    memcpy(calibTrk->nbad_l1,   trkcalib_.nbad_l1,    sizeof(calibTrk->nbad_l1));
    memcpy(calibTrk->nbad_l2,   trkcalib_.nbad_l2,    sizeof(calibTrk->nbad_l2));
    memcpy(calibTrk->nbad_l3,   trkcalib_.nbad_l3,    sizeof(calibTrk->nbad_l3));
    memcpy(calibTrk->cal_flag,  trkcalib_.cal_flag,   sizeof(calibTrk->cal_flag));      
    memcpy(calibTrk->checksum,  trkcalib_.checksum,   sizeof(calibTrk->checksum));      
    memcpy(calibTrk->DSPbad_par,trkcalib_.DSPbad_par, sizeof(calibTrk->DSPbad_par));      
    memcpy(calibTrk->DSPped_par,trkcalib_.DSPped_par, sizeof(calibTrk->DSPped_par));      
    memcpy(calibTrk->DSPsig_par,trkcalib_.DSPsig_par, sizeof(calibTrk->DSPsig_par));      

        cat <<  log4cpp::Priority::ERROR
        <<  "Fortran77 function trkcalibpkt error code = " << ERROR
        <<  "\n " << log4cpp::CategoryStream::ENDLINE;
    free(subData);    
}

