/** @file
 * $Source: /home/cvspamela/yoda/techmodel/CalibTrgReader.cpp,v $
 * $Id: CalibTrgReader.cpp,v 1.1 2004/05/11 10:12:35 nagni Exp $
 * $Author: nagni $
 * 
 * Implementation of the LogReader class.
* ToBeDone:
* Control the CRC for the entire data Packet not just for single records
 */

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cpp/Category.hh>
extern "C" {
    //Passo il path verso la il file temporaneo
    extern void trkcalibpkt_(int*, char*); 

    //Struct per il passaggio di dati da e verso la chiamata fortran
    extern struct {
      int   DAQmode[6];
      int   DSPnumber[6];
      int   calibnumber[6];
      int   ncalib_event[6];
      int   ped_l1[6];
      int   ped_l2[6];
      int   ped_l3[6];
      int   sig_l1[6];
      int   sig_l2[6];
      int   sig_l3[6];
      int   nbad_l1[6];
      int   nbad_l2[6];
      int   nbad_l3[6];
      int   cal_flag[6];
      int   checksum[6];
      int   DSPbad_par[6][3072];
      float DSPped_par[6][3072];
      float DSPsig_par[6][3072];
    } trkcalib_;

#include <dirent.h>
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

#include "event/CalibTrgEvent.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cpp::Category& cat = log4cpp::Category::getInstance("pamela.techmodel.CalibTrgReader");  

/**
 * Constructor. 
 */
CalibTrgReader::CalibTrgReader(void): 
  TechmodelAlgorithm(PacketType::CalibTrg, "TechmodelCalibTrgReader") { 
  cat <<  log4cpp::Priority::DEBUG
      <<  "Constructor "
      <<  "\n " << log4cpp::CategoryStream::ENDLINE;
  calibTrg = new CalibTrgEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string CalibTrgReader::GetVersionInfo(void) const {
  return 
    "$Header: /home/cvspamela/yoda/techmodel/CalibTrgReader.cpp,v 1.1 2004/05/11 10:12:35 nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void CalibTrgReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &calibTrg, calibTrg->Class());
}

/**
 * Unpack the CalibTrg event from an input file.
 */
void CalibTrgReader::RunEvent(int EventNumber, long int length) {
    int       ERROR;
    
    //the 2 bytes subtracted belong to the final event CRC bytes
    long int dataLength = length;// - (long int)2;

    char *subData = new char[dataLength];
    InputFile->read(subData, sizeof(unsigned char)*dataLength);

    //Skip the last two crc bytes already checked in UnpackPscu
    //This part have to be refactored!!!! too bad......
    InputFile->seekg((long int)2, std::ios::cur);

    //Scrivo un file temporaneo per passarlo alla routine
    //Speriamo di cambiare la routine per passargli un buffer.....
    DIR *dirp;
    std::string pathDir((char*)getenv("YODA_DATA"));
    pathDir = pathDir + "/";
    pathDir = pathDir + PamelaRun::GetRunName(EventNumber) + "/todatemp.dat";
    FILE *pfile;
    pfile = fopen((char*)pathDir.c_str(), "wb");
    fwrite(subData, 1, dataLength, pfile);
    fclose(pfile);

    //Call to the FORTRAN routin that unpack tracker events
    trkcalibpkt_(&ERROR, (char*)pathDir.c_str());

    remove((char*)pathDir.c_str());

    //Store the unpacked data
    memcpy(calibTrg->DAQmode,     trkcalib_.DAQmode,     sizeof(calibTrg->DAQmode));
    memcpy(calibTrg->DSPnumber,   trkcalib_.DSPnumber,   sizeof(calibTrg->DSPnumber));
    memcpy(calibTrg->calibnumber, trkcalib_.calibnumber, sizeof(calibTrg->calibnumber));
    memcpy(calibTrg->DSPnumber, trkcalib_.ncalib_event,  sizeof(calibTrg->ncalib_event));
    memcpy(calibTrg->ped_l1,    trkcalib_.ped_l1,     sizeof(calibTrg->ped_l1));
    memcpy(calibTrg->ped_l2,    trkcalib_.ped_l2,     sizeof(calibTrg->ped_l2));
    memcpy(calibTrg->ped_l3,    trkcalib_.ped_l3,     sizeof(calibTrg->ped_l3));
    memcpy(calibTrg->sig_l1,    trkcalib_.sig_l1,     sizeof(calibTrg->sig_l1));
    memcpy(calibTrg->sig_l2,    trkcalib_.sig_l2,     sizeof(calibTrg->sig_l2));
    memcpy(calibTrg->sig_l3,    trkcalib_.sig_l3,     sizeof(calibTrg->sig_l3));
    memcpy(calibTrg->nbad_l1,   trkcalib_.nbad_l1,    sizeof(calibTrg->nbad_l1));
    memcpy(calibTrg->nbad_l2,   trkcalib_.nbad_l2,    sizeof(calibTrg->nbad_l2));
    memcpy(calibTrg->nbad_l3,   trkcalib_.nbad_l3,    sizeof(calibTrg->nbad_l3));
    memcpy(calibTrg->cal_flag,  trkcalib_.cal_flag,   sizeof(calibTrg->cal_flag));      
    memcpy(calibTrg->checksum,  trkcalib_.checksum,   sizeof(calibTrg->checksum));      
    memcpy(calibTrg->DSPbad_par,trkcalib_.DSPbad_par, sizeof(calibTrg->DSPbad_par));      
    memcpy(calibTrg->DSPped_par,trkcalib_.DSPped_par, sizeof(calibTrg->DSPped_par));      
    memcpy(calibTrg->DSPsig_par,trkcalib_.DSPsig_par, sizeof(calibTrg->DSPsig_par));      

    cat <<  log4cpp::Priority::ERROR
        <<  "Fortran77 function trkcalibpkt error code = " << ERROR
        <<  "\n " << log4cpp::CategoryStream::ENDLINE;
    free(subData);    
    
}

