/** @file
 * $Source: /home/cvspamela/yoda/techmodel/CalibTrdReader.cpp,v $
 * $Id: CalibTrdReader.cpp,v 1.1 2004/05/11 10:12:35 nagni Exp $
 * $Author: nagni $
 * 
 * Implementation of the LogReader class.
* ToBeDone:
* Control the CRC for the entire data Packet not just for single records
 */

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cpp/Category.hh>
extern "C" {
#include <sys/time.h>
#include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

#include "event/CalibTrdEvent.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cpp::Category& cat = log4cpp::Category::getInstance("pamela.techmodel.CalibTrdReader");  

/**
 * Constructor. 
 */
CalibTrdReader::CalibTrdReader(void): 
  TechmodelAlgorithm(PacketType::Log, "TechmodelCalibTrdReader") { 
  cat <<  log4cpp::Priority::DEBUG
      <<  "Constructor "
      <<  "\n " << log4cpp::CategoryStream::ENDLINE;
  CalibTrd = new CalibTrdEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string CalibTrdReader::GetVersionInfo(void) const {
  return 
    "$Header: /home/cvspamela/yoda/techmodel/CalibTrdReader.cpp,v 1.1 2004/05/11 10:12:35 nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void CalibTrdReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &CalibTrd, CalibTrd->Class());
}

/**
 * Unpack the CalibTrd event from an input file.
 */
void CalibTrdReader::RunEvent(int EventNumber, long int length) {
    
    
}

