/** @file
 * $Source: /home/cvsmanager/yoda/event/tmtc/TmtcRecord.h,v $
 * $Id: TmtcRecord.h,v 4.1 2005/05/07 08:49:09 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * 16 May 2005 - added 4 more TM_TH_ANA. Updated the ClassDef to 2
 *
 * Header file for the TmtcRecord class.
 */
#ifndef TMTC_RECORD_H
#define TMTC_RECORD_H

#include "event/SubPacket.h"

namespace pamela {
  /**
   * TmtcRecord data Wrapper
   */
  class TmtcRecord: public TObject {
  private:
    
  public:
    /**
     * The On-Board-Time of the Record.
     */
    UINT32 TM_RECORD_OBT;

    /**
     * Conctac closure and bi-livel single ended digital acquisitions data from the TMTC board.
     *
     * From MSB to LSB: (significant IDs is the last one) <br>
     * TMTC_PACK_BIT(tm_val,TM_KRB_IPM1);<br>
     * TMTC_PACK_BIT(tm_val,TM_KRB_IPM2);<br>
     * TMTC_PACK_BIT(tm_val,TM_KRB_IPM3);<br>
     * TMTC_PACK_BIT(tm_val,TM_KRB_IPM4);<br>
     * TMTC_PACK_BIT(tm_val,TM_KRB_IPM5);<br>
     * TMTC_PACK_BIT(tm_val,TM_KRB_IPM6);<br>
     * <br>
     * TMTC_PACK_BIT(tm_val,TM_KHB_HOT_LATCHUP);<br>
     * TMTC_PACK_BIT(tm_val,TM_KHB_COLD_LATCHUP);<br>
     * <br>
     * TMTC_PACK_BIT(tm_val,TM_IDAQ_HOT_ALARM);<br>
     * TMTC_PACK_BIT(tm_val,TM_IDAQ_COLD_ALARM);<br>
     * <br>
     * TMTC_PACK_BIT(tm_val,TM_VCB_STANDBY);<br>
     * <br>
     * TMTC_PACK_BIT(tm_val,TM_VRL_HOT);<br>
     * TMTC_PACK_BIT(tm_val,TM_VRL_COLD);<br>
     * <br>
     * TMTC_PACK_BIT(tm_val,TM_PSB_ALARM);<br>
     * <br>
     * TMTC_PACK_BIT(tm_val,TM_TOFHV_HOT_ALARM);<br>
     * TMTC_PACK_BIT(tm_val,TM_TOFHV_COLD_ALARM);<br>
     */
    UINT16 TM_DIAG_AND_BILEVEL_ACQ;

    /**
     * Thermistor analogue acquisition data from the TMTC board. 
     *
     * The order from 0 to 11 is the following: (significant name are inside brackets)<br>
     * <br>
     * HB_WRITE_UINT16(HB_TMTC,tmtc_tmp_array[TM_IPM_TH]);<br>
     * HB_WRITE_UINT16(HB_TMTC,tmtc_tmp_array[TM_S1_TH]);<br>
     * <br>
     * HB_WRITE_UINT16(HB_TMTC,tmtc_tmp_array[TM_S4_TH]);<br>
     * HB_WRITE_UINT16(HB_TMTC,tmtc_tmp_array[TM_S4_ND_PLATE_TH]);<br>
     * <br>
     * HB_WRITE_UINT16(HB_TMTC,tmtc_tmp_array[TM_TRK_TH1]);<br>
     * HB_WRITE_UINT16(HB_TMTC,tmtc_tmp_array[TM_TRK_TH2]);<br>
     * <br>
     * HB_WRITE_UINT16(HB_TMTC,tmtc_tmp_array[TM_FLUID_IN_TH]);<br>
     * HB_WRITE_UINT16(HB_TMTC,tmtc_tmp_array[TM_FLUID_OUT_TH]);<br>
     * <br>
     * HB_WRITE_UINT16(HB_TMTC,tmtc_tmp_array[TM_VME_TH]);<br>
     * <br>
     * HB_WRITE_UINT16(HB_TMTC,tmtc_tmp_array[TM_DCDC_TH]);<br>
     * <br>
     * HB_WRITE_UINT16(HB_TMTC,tmtc_tmp_array[TM_CPU_TH1]);<br>
     * HB_WRITE_UINT16(HB_TMTC,tmtc_tmp_array[TM_CPU_TH2]);<br>
     * <br>
     * HB_WRITE_UINT16(unknow 1);<br>
     * HB_WRITE_UINT16(unknow 2);<br>
     * HB_WRITE_UINT16(unknow 3);<br>
     * HB_WRITE_UINT16(unknow 4);<br>
     */
    UINT16 TM_TH_ANA[16];


    /**
     * Digital data from the TMTC board.
     *
     * The order from 0 to 5 is the following: (significant name are inside brackets)<br>
     * <br>
     * HB_WRITE_UINT8(HB_TMTC,tmtc_tmp_array[TM_IPM_MOV_IPM1]);<br>
     * HB_WRITE_UINT8(HB_TMTC,tmtc_tmp_array[TM_IPM_MOV_IPM2]);<br>
     * HB_WRITE_UINT8(HB_TMTC,tmtc_tmp_array[TM_IPM_MOV_IPM3]);<br>
     * HB_WRITE_UINT8(HB_TMTC,tmtc_tmp_array[TM_IPM_MOV_IPM4]);<br>
     * HB_WRITE_UINT8(HB_TMTC,tmtc_tmp_array[TM_IPM_MOV_IPM5]);<br>
     * HB_WRITE_UINT8(HB_TMTC,tmtc_tmp_array[TM_IPM_MOV_IPM6]);<br>
     */
    UINT8  TM_DEA_ANA[6];

    TmtcRecord(void);
    ~TmtcRecord(void){};
    ClassDef(TmtcRecord, 2)
  };
}

#endif /* TMTC_RECORD_H */

