
#ifndef TABDUMP_RECORD_H
#define TABDUMP_RECORD_H
#include <TArrayI.h>
#include "../SubPacket.h"

namespace pamela {
  /**
   * TabDumpBlock data Wrapper
    * 
   * The TabDumpEvent represent the TabDump packet and contain the values 
   * of the PAMELA CPU software's arrays written in Mass Memory between 
   * two storing operations.
   */
  class TabDumpRecord: public TObject {
  private:
    
  public:
    /**
     * The table ID.
     */   
    UINT8     Tab_ID;
    
    /**
     * The table's number of rows.
     */   
    UINT8     Nrow;

    /**
     * The table's number of columns.
     */   
    UINT8     Ncol;

    /**
     * An array of Integers containing the values of the table.
     */   
    TArrayI  *Data;
  
    TabDumpRecord(void);
    ~TabDumpRecord(void){};
    ClassDef(TabDumpRecord, 1)
  };
}

#endif /* TABDUMP_RECORD_H */

