/** @file
 * $Source: /home/cvspamela/yoda/event/physics/anticoinc/AnticounterEvent.h,v $
 * $Id: AnticounterEvent.h,v 1.6 2004/03/16 10:18:28 nagni Exp $
 * $Author: nagni $
 * 
 * Header file for the raw anticoincidence events
 */
#ifndef ANTICOUNTER_EVENT_H
#define ANTICOUNTER_EVENT_H

#include <exception>

#include <TObject.h>

#include "event/SubPacket.h"

namespace pamela {
  /**
   * Namespace for all code related to the anticoincidence unit.
   */
  namespace anticoinc {
    /**
     * Raw anticounter subpacket
     */
    class AnticounterEvent: public pamela::SubPacket {
    private:
      int Hit;                  // Global hit flag
      int CasHit[4];            // Which CAS PMTs have activity
      int CatHit[4];            // Which CAT PMTs have activity
      int CasCluster[88];       // Cluster ID in CAS shift registers
      int CatCluster[88];       // Cluster ID in CAT shift registers
      int StatusFlag;           // Status of the ANTI system
      int StatusPmtFlag[16];    // Database driven status flag;
    public:
      AnticounterEvent(void);
      ~AnticounterEvent(void);
      int GetHit(void) const { return Hit; }
      const int* GetCasHit(void) const { return CasHit; }
      const int* GetCatHit(void) const { return CatHit; }
      const int* GetCasCluster(void) const { return CasCluster; }
      const int* GetCatCluster(void) const { return CatCluster; }
      int GetStatusFlag(void) const { return StatusFlag; }
      const int* GetStatusPmtFlag(void) const { return StatusPmtFlag; }
      // ... and the setters ...
      ClassDef(AnticounterEvent, 1)
    };
  }
}
#endif /* ANTICOUNTER_EVENT_H */
