/** @file
 * $Source: /home/cvsmanager/yoda/event/physics/S4/S4Event.h,v $
 * $Id: S4Event.h,v 4.5 2005/08/29 08:27:35 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Header file for the raw anticoincidence events
 */
#ifndef S4_EVENT_H
#define S4_EVENT_H

#include "../../SubPacket.h"

namespace pamela {
  /**
   * Namespace for all code related to the S4 unit.
   */
  namespace S4 {
    /**
     * S4 subpacket data wrapper.
     */
    class S4Event: public pamela::SubPacket {
    private:
 
    public:

    /**
     * The register status.
     */
    UINT8  S4_REG_STATUS;

    /**
     * The data.
     */
    UINT16 S4_DATA;

    /**
     * The Command number.
     */
    UINT8  S4_CMD_NUM;

    /**
     * The response length.
     */
    UINT16 S4_RESP_LENGHT;

    /**
     * The overall crc.
     */
    UINT8  S4_OVERALL_CHKCODE;

    /**
     * The data validity flag.
     * 
     * Description:          <BR>
     * 1: S4 data NOT found. <BR>
     * 0: S4 data ok.        <BR>
     */
    UINT8  unpackError;

    S4Event(void);
      ~S4Event(void);

      ClassDef(S4Event, 2)
    };
  }
}
#endif /* S4_EVENT_H */
