/** @file
 * $Source: /home/cvsmanager/yoda/event/physics/calorimeter/CalorimeterEvent.h,v $
 * $Id: CalorimeterEvent.h,v 4.0 2005/03/06 04:33:01 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Header file for the raw calorimeter events
 */
#ifndef CALORIMETER_EVENT_H
#define CALORIMETER_EVENT_H

#include "event/SubPacket.h"

namespace pamela {
  /** 
   * Namespace for all calorimeter related code.
   */
  namespace calorimeter {
    /**
     * Techmodel calorimeter data.
     */
    class CalorimeterEvent: public pamela::SubPacket {
    private:

    public:
      CalorimeterEvent(void);
      ~CalorimeterEvent(void);
        int iev;
        int stwerr[4];
        float perror[4];
        float dexy[2][22][96];
        float dexyc[2][22][96];
        float base[2][22][6];
        float calselftrig[4][7];
        float calIItrig[4];
        float calstriphit[4];
        float calDSPtaberr[4];
        float calevnum[4];

    /**
     * The data validity (to be defined).
     * 
     * Description:         <BR>
     */
        UINT8 unpackError;
      ClassDef(CalorimeterEvent, 2)
    };
  }
}
#endif /* CALORIMETER_EVENT_H */
