
#ifndef NEUTRON_RECORD_H
#define NEUTRON_RECORD_H

#define UINT8  unsigned char

#include <TObject.h>


namespace pamela {
    namespace neutron {
    /**
    * NeutronRecord data Wrapper
    */
    class NeutronRecord: public TObject {

    public:
    
    /**
     * The number of neutrons counted during a physics event.
     */
    UINT8    trigPhysics;

    /**
     * The number of neutrons ("background neutrons") counted between two physics events on the higher plane of the Neutron Detector;
     * the counter cannot count more than 16.
     */
    UINT8    upperBack;

    /**
     * The number of neutrons ("background neutrons") counted between two physics events on the lower plane of the Neutron Detector.
     * the counter cannot count more than 16.
     */
    UINT8    bottomBack;

    NeutronRecord(void);
        
    ClassDef(NeutronRecord, 1)
  };
}
}
#endif /* NEUTRON_RECORD_H */

