
#ifndef NEUTRON_EVENT_H
#define NEUTRON_EVENT_H

#include "event/SubPacket.h"
#include "event/physics/neutronDetector/NeutronRecord.h"
#include <TClonesArray.h>

namespace pamela {
    namespace neutron {
    /**
    * NeutronEvent data Wrapper
    */
    class NeutronEvent: public pamela::SubPacket {
    private:
        static TClonesArray *fgRecords;
    
    public:
        TClonesArray   *Records;
        
        /*
         * unpackError = 0 ---- no error
         * unpackError = 1 ---- neutron data not found
         *
         */
        unsigned short  unpackError;

        NeutronEvent(void);
        ~NeutronEvent(void);

        ClassDef(NeutronEvent, 2)
    };
    }
}
#endif /* NEUTRON_EVENT_H */

