/** @file
 * $Source: /home/cvsmanager/yoda/event/mcmd/McmdRecord.h,v $
 * $Id: McmdRecord.h,v 3.0 2005/03/04 15:54:11 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Header file for the McmdRecord class.
 */
#ifndef MCMD_RECORD_H
#define MCMD_RECORD_H

#include "event/SubPacket.h"
#include <TArrayC.h>

namespace pamela {
  /**
   * McmdRecord data Wrapper
   */
  class McmdRecord: public TObject {

  public:
    /**
     * Get the run name according to a certain run number.
     * @param run Run number.
     * @return a string with the run name.
     */
    UINT32 MCMD_RECORD_OBT;
    int  Mcmd_Block_crc_ok;
    
    UINT16         SeqID;
    UINT8          Tbit;
    UINT8          ID1;
    UINT16         McmdLength;
    UINT32         TimeTag;
    TArrayC       *McmdData;
    UINT8          endID;


    McmdRecord(void);
        
    /*void setMcmdData(const BYTE val[]) {
      if (McmdLength > 0){
	McmdData = new BYTE[McmdLength];
	memcpy(McmdData, val, McmdLength);
      }
    };*/
    
    ClassDef(McmdRecord, 1)
  };
}

#endif /* MCMD_RECORD_H */

