/** @file
 * $Source: /home/cvsmanager/yoda/event/log/LogEvent.h,v $
 * $Id: LogEvent.h,v 4.0 2005/03/06 04:33:01 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Header file for the LogEvent class.
 */
#ifndef LOG_EVENT_H
#define LOG_EVENT_H

#include <vector>
#include "event/SubPacket.h"
#include "event/log/LogRecord.h"
#include <TClonesArray.h>

using namespace std;

namespace pamela {
  /**
   * LogEvent data Wrapper.
   *
   * The LogEvent represents the "LogEvent" packet generated by the PAMELA CPU software
   * and is a collection of several logs generated during PAMELA operations
   * and recorded in the CPU RAM between two storing operations.
   */
  class LogEvent: public pamela::SubPacket {
  private:
  
    static TClonesArray *fgRecords;
  public:
    /**
     * The Compilation Timestamp of the PAMELA CPU software.
     */
    UINT32 COMPILATION_TIMESTAMP;

    /**
     * Contain multiple instances of pamela::LogRecord type.
     */
    TClonesArray* Records;
    
    LogEvent(void);
    ~LogEvent(void);
    
    ClassDef(LogEvent, 1)
  };
}

#endif /* LOG_EVENT_H */

