#ifndef ARRDUMP_EVENT_H
#define ARRDUMP_EVENT_H

#include "ArrDumpRecord.h"
#include <TClonesArray.h>

namespace pamela {
  /**
   * ArrDumpEvent data Wrapper
   * 
   * The pamela::ArrDumpEvent represents the ArrDump packet generated by the PAMELA CPU software.
   * It contains the values of the PAMELA CPU software's vectors written in Mass Memory between 
   * two storing operations.
   */
  class ArrDumpEvent: public pamela::SubPacket {
  private:
    static TClonesArray *fgRecords;
  public:
    
    /**
     * Contain multiple instances of pamela::ArrDumpRecord type.
     */
    TClonesArray* Records;

    /**
     * The Compilation Timestamp of the PAMELA CPU software.
     */
    UINT32          PARAMETER_STAMP;

    ArrDumpEvent(void);
    ~ArrDumpEvent(void);
    
    ClassDef(ArrDumpEvent, 1)
  };
}

#endif /* ARRDUMP_EVENT_H */

