/** @file
 * $Source: /afs/ba.infn.it/user/pamela/src/CVS/yoda/event/PacketType.h,v $
 * $Id: PacketType.h,v 6.3 2006/05/30 19:10:02 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Header file for the PacketType class.
 */
#ifndef PACKETTYPE_H
#define PACKETTYPE_H
#include <string>
#include <sstream>
#include <Rtypes.h> //Substituted by Maurizio 05 Feb 2004

namespace pamela {
  /**
   * The type of a packet type.
   */
  class PacketType {
  private: 
    /**
     * A magic number to distinguish between the Packets. A "packet
     * type" is central for the whole YODA analysis package. The data
     * flow within YODA is organized within different streams which
     * are distinguished by their "packet type". The main data stream
     * has the package type "Physics" that handles all physics
     * events. Other important types are "Housekeeping" and
     * "Calibration". The different package type originate in the
     * differnet package types in the raw data file and correspond to
     * them.
     */
    int Magic;
    /**
     * The name of the packet type.
     */
    std::string Name;
  protected:
    PacketType(int, std::string);
    virtual const char* Print(void) const { return "Packet Type"; }
    virtual ~PacketType();
  public:
    /**
     * Get the name of the packet type 
     */
    const std::string GetName(void) const { return Name; }
    /**
     * Get the magic number of the packet type 
     */
    const int GetMagic(void) const { return Magic; }

    static const PacketType* Pscu;         /**< Pscu event packets */
    static const PacketType* PhysEndRun;
    static const PacketType* CalibCalPulse1;
    static const PacketType* CalibCalPulse2;
    static const PacketType* Physics;
    static const PacketType* CalibTrkBoth;
    static const PacketType* CalibTrk1;
    static const PacketType* CalibTrk2;
    static const PacketType* CalibTof;
    static const PacketType* CalibS4;
    static const PacketType* CalibCalPed;
    static const PacketType* Calib1_Ac1;
    static const PacketType* Calib2_Ac1;
    static const PacketType* Calib1_Ac2;
    static const PacketType* Calib2_Ac2;
    static const PacketType* CalibCal;
    static const PacketType* RunHeader;
    static const PacketType* RunTrailer;
    static const PacketType* CalibHeader;
    static const PacketType* CalibTrailer;
    static const PacketType* InitHeader;
    static const PacketType* InitTrailer;
    static const PacketType* EventTrk;
    static const PacketType* Log;
    static const PacketType* VarDump;
    static const PacketType* ArrDump;
    static const PacketType* TabDump;
    static const PacketType* Tmtc;
    static const PacketType* Mcmd;
    static const PacketType* ForcedFECmd;
    static const PacketType* Ac1Init;
    static const PacketType* CalInit;
    static const PacketType* TrkInit;
    static const PacketType* TofInit;
    static const PacketType* TrgInit;
    static const PacketType* NdInit;
    static const PacketType* S4Init;
    static const PacketType* Ac2Init;
    static const PacketType* CalAlarm;
    static const PacketType* Ac1Alarm;
    static const PacketType* TrkAlarm;
    static const PacketType* TrgAlarm;
    static const PacketType* TofAlarm;
    static const PacketType* S4Alarm;
    static const PacketType* Ac2Alarm;
    static const PacketType* TsbT;
    static const PacketType* TsbB;
    static const PacketType* Invalid;

    ClassDef(PacketType, 6)
  };
}

#endif /* PACKETTYPE_H */
