/** @file
 * $Source: /home/cvsmanager/yoda/event/SubPacket.h,v $
 * $Id: SubPacket.h,v 5.1 2006/02/04 12:37:43 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Header file for the SubPacket class.
 */
#ifndef SUB_PACKET_H
#define SUB_PACKET_H

#define  UINT32 unsigned int
#define  UINT16 unsigned short
#define  UINT8  unsigned char
#include "PacketType.h"
#include "SubDetector.h"
#include "TObject.h"

namespace pamela {
  /**
   * A SubPacket is the basic structure of all event data in the ROOT storage.
   * Every ROOT tree is built on top of one SubPacket. An analys step
   * which wants to save data needs to create a SubPacket.
   */
  class SubPacket: public TObject {
  private:
    /**
     * The packet type of the sub packet.
     */
    const pamela::PacketType* Type; //!
    /**
     * The subdetector this packet belongs to, or 0 if it is not specific to
     * any subdetector.
     */ 
    const pamela::SubDetector* Detector; //!
    /**
     * The name of the subpacket.
     */
    std::string SubPacketName; //!
  protected:
    SubPacket(std::string, const pamela::PacketType* = 0,  const pamela::SubDetector* = 0);
    virtual const char* Print(){ return "SubType"; }
    std::stringstream oss; //!
  public:
    SubPacket(void);
    /**
     * Get the name of the SubPacket. 
     */
    virtual std::string GetSubPacketName(void) const { return SubPacketName; }
    /**
     * Return TRUE if the SubPacket belongs to a certain subdetector. 
     */
    bool IsDetectorSpecific(void) const { return (Detector != 0); }
    /**
     * Get the subdetector if the SubPacket is detector specific. 
     */
    const pamela::SubDetector* GetSubDetector(void) const { return Detector; }
    /**
     * Get the packet type (physics, orbital etc.) the SubPacket belongs to.
     */
    const pamela::PacketType* GetPacketType(void) const { return Type; }
   
    ClassDef(SubPacket, 1)
  };
}

#endif /* SUB_PACKET_H */

