#ifndef RUNTRAILER_EVENT_H
#define RUNTRAILER_EVENT_H

#include "SubPacket.h"

namespace pamela {
    /**
    * RunTrailerEvent data Wrapper.
    * The RunTrailerEvent represent a RunHeader packet generated by the PAMELA CPU software.
    * A RunTrailer packet marks the end of a Run, that is an acquisition loop. <BR>
    * It is written in the MM just after the break of the run process. 
    * Run process can be stoppede due to different reasons, including dowload, alarms, 
    * ordinal time out, RunTrailer is written after ``End of run'' acquistion packet.
    */
  class RunTrailerEvent: public pamela::SubPacket {
  private:
   
  public:
    RunTrailerEvent(void);
    
    /**
     * The total packet counter value (only physics packets) since software bootstrap.
     */
    UINT32 PKT_COUNTER;

    /**
     * The total packet counter value, for the ended run; the end of run packet excluded.
     */
    UINT32 PKT_ReadyCounter;

    /**
     * The last On-Board-Time on which has been received the LAST_TIME_SYNC_INFO.
     * This parameter is the copy of On-Board-Time received in the last Timesync MCMD.
     * If zero means TimeSync mcmd nerver come.
     */
    UINT32 OBT_TYME_SYNC;

    /**
     * The last received TimeSync.
     * This parameter is the copy of TimeSync received in the last Timesync MCMD.
     * If zero means TimeSync mcmd nerver come.
     */
    UINT32 LAST_TYME_SYNC_INFO;
    
    ClassDef(RunTrailerEvent, 1)
  };
}

#endif /* RUNTRAILER_EVENT_H */

