/** @file
 * $Source: /home/cvsmanager/yoda/event/PscuHeader.cpp,v $
 * $Id: PscuHeader.cpp,v 5.1 2006/02/04 12:37:43 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Implementation of the PscuHeader class.
 */
#include <log4cxx/logger.h>
#include "PscuHeader.h"

using namespace pamela;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.PscuHeader"));
//static std::stringstream oss;

/**
 * Create an PscuHeader object.
 */
PscuHeader::PscuHeader():
  OrbitalTime(0),
  PacketId1(0),
  PacketId2(0),
  Counter(0),
  PacketLenght(0) { }

PscuHeader::~PscuHeader() { }

/**
 * Get the packet type of this header.
 */
const PacketType* PscuHeader::GetPacketType(void) const throw (UnidentifiedPacketException) {
  switch (PacketId1) {
    case 0x07: return PacketType::PhysEndRun;
    case 0x08: return PacketType::CalibCalPulse1;
    case 0x09: return PacketType::CalibCalPulse2;
    case 0x10: return PacketType::Physics;
    case 0x12: return PacketType::CalibTrk1;
    case 0x13: return PacketType::CalibTrk2;
    case 0x16: return PacketType::CalibTof;
    case 0x17: return PacketType::CalibS4;
    case 0x18: return PacketType::CalibCalPed;
    case 0x19: return PacketType::Calib1_Ac1;
    case 0x1A: return PacketType::Calib2_Ac1;
    case 0x1B: return PacketType::Calib1_Ac2;
    case 0x1C: return PacketType::Calib2_Ac2;
    case 0x20: return PacketType::RunHeader;
    case 0x21: return PacketType::RunTrailer;
    case 0x22: return PacketType::CalibHeader;
    case 0x23: return PacketType::CalibTrailer;
    case 0x24: return PacketType::InitHeader;
    case 0x25: return PacketType::InitTrailer;
    case 0x50: return PacketType::Log;
    case 0x51: return PacketType::VarDump;
    case 0x52: return PacketType::ArrDump;
    case 0x53: return PacketType::TabDump;
    case 0x54: return PacketType::Tmtc;
    case 0x55: return PacketType::Mcmd;
    case 0x60: return PacketType::ForcedFECmd;
    case 0x70: return PacketType::Ac1Init;
    case 0x71: return PacketType::CalInit;
    case 0x72: return PacketType::TrkInit;
    case 0x73: return PacketType::TofInit;
    case 0x74: return PacketType::TrgInit;
    case 0x75: return PacketType::NdInit;
    case 0x76: return PacketType::S4Init;
    case 0x77: return PacketType::Ac2Init;
    case 0x81: return PacketType::CalAlarm;
    case 0x82: return PacketType::AcAlarm;
    case 0x83: return PacketType::TrkAlarm;
    case 0x84: return PacketType::TrgAlarm;
    case 0x85: return PacketType::TofAlarm;
    case 0x86: return PacketType::S4Alarm;
    case 0xA1: return PacketType::TsbT;
    case 0xAB: return PacketType::TsbB;
  
  default: {
    throw UnidentifiedPacketException(PacketId1);
  }
  }
}


ClassImp(PscuHeader)


