/** @file
 * $Source: /home/cvsmanager/yoda/event/PacketType.cpp,v $
 * $Id: PacketType.cpp,v 6.0 2006/02/07 17:11:07 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Implementation of the PacketType class.
 * modified Nagni 2004/03/01
 */
#include "PacketType.h"

using namespace pamela;

//The Pscu packet is fake because doesn't really own to any specific PscuPacket
//is only a facility packet for the Header
const PacketType* PacketType::Pscu              = new PacketType(0xaa, "Pscu");
const PacketType* PacketType::PhysEndRun        = new PacketType(0x07, "PhysEndRun");
const PacketType* PacketType::CalibCalPulse1    = new PacketType(0x08, "CalibCalPulse1");
const PacketType* PacketType::CalibCalPulse2    = new PacketType(0x09, "CalibCalPulse2");
const PacketType* PacketType::Physics           = new PacketType(0x10, "Physics");
const PacketType* PacketType::CalibTrk1         = new PacketType(0x12, "CalibTrk1");
const PacketType* PacketType::CalibTrk2         = new PacketType(0x13, "CalibTrk2");
const PacketType* PacketType::CalibTof          = new PacketType(0x16, "CalibTof");
const PacketType* PacketType::CalibS4           = new PacketType(0x17, "CalibS4");
const PacketType* PacketType::CalibCalPed       = new PacketType(0x18, "CalibCalPed");
const PacketType* PacketType::Calib1_Ac1        = new PacketType(0x19, "Calib1_Ac1");
const PacketType* PacketType::Calib2_Ac1        = new PacketType(0x1A, "Calib2_Ac1");
const PacketType* PacketType::Calib1_Ac2        = new PacketType(0x1B, "Calib1_Ac2");
const PacketType* PacketType::Calib2_Ac2        = new PacketType(0x1C, "Calib2_Ac2");
const PacketType* PacketType::RunHeader         = new PacketType(0x20, "RunHeader");
const PacketType* PacketType::RunTrailer        = new PacketType(0x21, "RunTrailer");
const PacketType* PacketType::CalibHeader       = new PacketType(0x22, "CalibHeader");
const PacketType* PacketType::CalibTrailer      = new PacketType(0x23, "CalibTrailer");
const PacketType* PacketType::InitHeader        = new PacketType(0x24, "InitHeader");
const PacketType* PacketType::InitTrailer       = new PacketType(0x25, "InitTrailer");
const PacketType* PacketType::EventTrk       	= new PacketType(0x25, "EventTrk");
const PacketType* PacketType::Log               = new PacketType(0x50, "Log");
const PacketType* PacketType::VarDump           = new PacketType(0x51, "VarDump");
const PacketType* PacketType::ArrDump           = new PacketType(0x52, "ArrDump");
const PacketType* PacketType::TabDump           = new PacketType(0x53, "TabDump");
const PacketType* PacketType::Tmtc              = new PacketType(0x54, "Tmtc");
const PacketType* PacketType::Mcmd              = new PacketType(0x55, "Mcmd");
const PacketType* PacketType::ForcedFECmd       = new PacketType(0x60, "ForcedFECmd");
const PacketType* PacketType::Ac1Init           = new PacketType(0x70, "Ac1Init");
const PacketType* PacketType::CalInit           = new PacketType(0x71, "CalInit");
const PacketType* PacketType::TrkInit           = new PacketType(0x72, "TrkInit");
const PacketType* PacketType::TofInit           = new PacketType(0x73, "TofInit");
const PacketType* PacketType::TrgInit           = new PacketType(0x74, "TrgInit");
const PacketType* PacketType::NdInit            = new PacketType(0x75, "NdInit");
const PacketType* PacketType::S4Init            = new PacketType(0x76, "S4Init");
const PacketType* PacketType::Ac2Init           = new PacketType(0x77, "Ac2Init");
const PacketType* PacketType::CalAlarm          = new PacketType(0x81, "CalAlarm");
const PacketType* PacketType::AcAlarm           = new PacketType(0x82, "AcAlarm");
const PacketType* PacketType::TrkAlarm          = new PacketType(0x83, "TrkAlarm");
const PacketType* PacketType::TrgAlarm          = new PacketType(0x84, "TrgAlarm");
const PacketType* PacketType::TofAlarm          = new PacketType(0x85, "TofAlarm");
const PacketType* PacketType::S4Alarm           = new PacketType(0x86, "S4Alarm");
const PacketType* PacketType::TsbT              = new PacketType(0xA1, "TsbT");
const PacketType* PacketType::TsbB              = new PacketType(0xAB, "TsbB");


const PacketType* PacketType::Invalid     = new PacketType(-1, "Invalild");

/**
 * Constructor: Build a packet type with a specific magic number and name.
 */
PacketType::PacketType(int m, std::string s): Magic(m), Name(s) { }

ClassImp(PacketType)
