/** @file
 * $Source: /home/cvsmanager/yoda/event/RegistryEvent.h,v $
 * $Id: RegistryEvent.h,v 5.4 2006/02/07 11:20:47 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Header file for the RegistryEvent class.
 */
#ifndef REGISTRY_EVENT_H
#define REGISTRY_EVENT_H

#include "TObject.h"
#include "TString.h"
namespace pamela {
  /**
   * RegistryEvent data Wrapper
   */
  class RegistryEvent: public TObject {
  private:
    
  public:
  public:
    /* This is the absolute Time of the event calculated after data unpacking*/
    ULong64_t   absTime;

    /* Name of the unpacked file this data cames from.
     * The reason for this is beacuse if multiple data are collected from several
     * files using the same xxx.Event.root & xxx.Registry.root structure, in this way you 
     * can reconstruct from which file this data cames from.
    */
    TString   originFile;
    
    /* Because on transmission multiple copies of data could be unpacked, a special procedure 
     * collect all the event just one time each. This parameter is related to the entry relative
     * to that selected event.
    */
    unsigned int        event;
            
    RegistryEvent();
    ~RegistryEvent(void){};
    ClassDef(RegistryEvent, 2)
  };
}

#endif /* REGISTRY_EVENT_H */

