/** @file
 * $Source: /home/cvsmanager/yoda/event/EventHeader.h,v $
 * $Id: EventHeader.h,v 3.0 2005/03/04 15:54:11 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Header file for the EventHeader class.
 */
#ifndef EVENT_HEADER_H
#define EVENT_HEADER_H

#include <iostream>
#include <TROOT.h> 
#include <TTree.h> 


#include "SubPacket.h"
#include "PscuHeader.h"
#include "EventCounter.h"


namespace pamela { 
  /**
   * Common raw event header. It contains the PSCU header and the Counter.
   */
  class EventHeader: public pamela::SubPacket {
  private:
    /** Contains the counters of the current event number and the
     * last event numbers of the other event read before the current
     * event. */
    pamela::EventCounter Counter; 
    /** Event Information read from the Pamela CPU board. */
    pamela::PscuHeader Pscu;
  public:
    EventHeader(int = 0);
    EventHeader(const pamela::PacketType *);
    ~EventHeader();
    /** Get the event counter. */
    pamela::EventCounter *GetCounter() { return &Counter; }
    /** Get the PSCU header (information from the Pamela CPU board). */
    pamela::PscuHeader *GetPscuHeader() throw (Exception) { return &Pscu; }
    ClassDef(EventHeader, 2)
  };
} 

#endif /* EVENT_HEADER_H */
