/** @file
 * $Source: /home/cvsmanager/yoda/event/Exception.h,v $
 * $Id: Exception.h,v 3.0 2005/03/04 15:54:11 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Header file for the exceptions of Pamela.
 */
#ifndef EXCEPTION_H
#define EXCEPTION_H
#include <exception>
#include <stdio.h>
#include "SubPacket.h"

using namespace std;
namespace pamela {

  class Exception: public exception {
    
  private:
    
  protected:
    const char *message;
    char buff [100];
  public:
    Exception(const char *msg = "message"): message(msg){ }
    virtual ~Exception () throw(){ }
    virtual const char* print () const throw () { return message; }
  };

  class NotFoundEnvironmentVarException: public Exception {
  public:
    NotFoundEnvironmentVarException::NotFoundEnvironmentVarException(const char* msg):  Exception(msg) {}
    NotFoundEnvironmentVarException::~NotFoundEnvironmentVarException () throw(){ }
  };

  class UnidentifiedPacketException: public Exception {
  private:
    UINT8     pktId;
  public:
    UnidentifiedPacketException::UnidentifiedPacketException(UINT8 id): 
    Exception("Unidentified PacketType - Id: ") {
        pktId = id;
    }
    UnidentifiedPacketException::~UnidentifiedPacketException () throw(){ }
    const char* UnidentifiedPacketException::print () const throw () { 
        sprintf((char*)buff," %s 0x%x", message, pktId);
        return buff;
    }
  };

  class WrongCRCException: public Exception {
  public:
    WrongCRCException::WrongCRCException(const char* msg):  Exception(msg) {}
    WrongCRCException::~WrongCRCException () throw(){ }
  };

  class WrongCRCHeaderException: public Exception {
  public:
    WrongCRCHeaderException::WrongCRCHeaderException(const char* msg):  Exception(msg) {}
    WrongCRCHeaderException::~WrongCRCHeaderException () throw(){ }
  };


  class LengthException: public Exception {
  public:
    LengthException::LengthException(const char* msg):  Exception(msg) { }
    LengthException::~LengthException () throw(){ }
  };


  class NotExistingAlgorithmException: public Exception {
  public:
    NotExistingAlgorithmException::NotExistingAlgorithmException(const char *msg):  Exception(msg) { }
    NotExistingAlgorithmException::~NotExistingAlgorithmException () throw(){ }
  };
  
  class NotExistingCounterException: public Exception {
  public:
    NotExistingCounterException::NotExistingCounterException(const char *msg):  Exception(msg) { }
    NotExistingCounterException::~NotExistingCounterException () throw(){ }
  };

}
#endif /* EXCEPTION_H */
