/** @file
 * $Source: /home/cvspamela/yoda/event/OrbitalEvent.h,v $
 * $Id: OrbitalEvent.h,v 1.6 2004/03/16 10:18:28 nagni Exp $
 * $Author: nagni $
 * 
 * Header file for the OrbitalEvent class.
 */
#ifndef ORBITAL_EVENT_H
#define ORBITAL_EVENT_H

#include "SubPacket.h"

namespace pamela {
  /**
   * Information events about the orbit.
   */
  class OrbitalEvent: public pamela::SubPacket {
  private:
    int Time; /**< Orbit time. */
    int Orbit; /**< Orbit number. */
    float Height; /**< Height above N.N. in meters. */
  public:
    OrbitalEvent(void);
    /** Get the orbit time. */
    int GetTime(void) const { return Time; }
    /** Get the orbit number. */
    int GetOrbit(void) const { return Orbit; }
    /** Get the height of the satellite in meters. */
    float GetHeight(void) const { return Height; }
    void Set(int, int, float);
    ClassDef(OrbitalEvent, 1)
  };
}

#endif /* ORBITAL_EVENT_H */

