/** @file
 * $Author: kusanagi $
 * $Date: 2006/02/07 17:11:09 $
 * $Revision: 6.0 $
 * 
 * Implementation of the NdInitReader class.
 */

#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.NdInitReader"));

/**
 * Constructor. 
 */
NdInitReader::NdInitReader(void): 
  TechmodelAlgorithm(PacketType::NdInit, "TechmodelAcInitReader") { 
  logger->debug(_T("Constructor"));
  ndInit = new NdInitEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string NdInitReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/NdInitReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void NdInitReader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &ndInit, ndInit->Class());
}

/**
 * Unpack the NdInit event, which is a dummy packet, from an input file.
 * The CPU does not add any CRC control at the packet end.
 * @param EventNumber 
 * @param dataLength 
 */
void NdInitReader::RunEvent(int EventNumber, long int dataLength) throw (WrongCRCException){
    char      subData[dataLength];
    memset(subData,  0, dataLength*sizeof(char));
    InputFile->read(subData, sizeof(subData));
    ndInit->ndInitData        = new TArrayC(dataLength, subData);
}

