
// Implementation of the TrkInitReader class.
 

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cxx/logger.h>
extern "C" {
#include <sys/time.h>
#include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

#include "event/TrkInitEvent.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.TrkInitReader"));

/**
 * Constructor. 
 */
TrkInitReader::TrkInitReader(void): 
  TechmodelAlgorithm(PacketType::TrkInit, "TechmodelTrkInitReader") { 
  logger->debug(_T("Constructor"));
  trkInit = new TrkInitEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string TrkInitReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/TrkInitReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void TrkInitReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &trkInit, trkInit->Class());
}

/**
 * Unpack the TrkInit event from an input file.
 */
void TrkInitReader::RunEvent(int EventNumber, long int length) throw (WrongCRCException){

}

