#ifndef TABDUMP_EVENT_H
#define TABDUMP_EVENT_H

#include "event/tabDump/TabDumpRecord.h"
#include <TClonesArray.h>

using namespace std;

namespace pamela {
  /**
   * TabDumpEvent data Wrapper.
   *
   * The pamela::TabDumpEvent represents the TabDump packet generated by the PAMELA CPU software.
   * It contains the values of the PAMELA CPU software's vectors written in Mass Memory between 
   * two storing operations.
   */
  class TabDumpEvent: public pamela::SubPacket {
  private:
    static TClonesArray *fgRecords;
  public:

    /**
     * Contain multiple instances of pamela::TabDumpRecord type.
     */
    TClonesArray*   Records;

    /**
     * The Compilation Timestamp of the PAMELA CPU software.
     */
    UINT32          PARAMETER_STAMP;

    TabDumpEvent(void);
    ~TabDumpEvent(void);
    
    ClassDef(TabDumpEvent, 1)
  };
}

#endif /* TABDUMP_EVENT_H */

