
// Implementation of the S4AlarmReader class.
 

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cxx/logger.h>
extern "C" {
#include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.S4AlarmReader"));

/**
 * Constructor. 
 */
S4AlarmReader::S4AlarmReader(void): 
  TechmodelAlgorithm(PacketType::S4Alarm, "S4AlarmReader") { 
  logger->debug(_T("Constructor"));
  s4Alarm = new S4AlarmEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string S4AlarmReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/s4AlarmReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void S4AlarmReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &s4Alarm, s4Alarm->Class());
  logger->debug(_T("Initialize"));
}

/**
 * Unpack the S4Alarm event from an input file.
 */
void S4AlarmReader::RunEvent(int EventNumber, long int length) throw (WrongCRCException){
    
    
}

