/** @file
 * $Author: kusanagi $
 * $Date: 2006/02/07 17:11:10 $
 * $Revision: 6.0 $
 * 
 * Implementation of the TrgInitReader class.
 */

#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;
static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.TrgInitReader"));

/**
 * Constructor. 
 */
TrgInitReader::TrgInitReader(void): 
  TechmodelAlgorithm(PacketType::TrgInit, "TechmodelTrgInitReader") { 
  logger->debug(_T("Constructor"));
  trgInit = new TrgInitEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string TrgInitReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/TrgInitReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void TrgInitReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &trgInit, trgInit->Class());
}

/**
 * Unpack the TrgInit event from an input file.
 * The CPU does not add any CRC control at the packet end.
 * @param EventNumber 
 * @param dataLength 
 */
void TrgInitReader::RunEvent(int EventNumber, long int dataLength) throw (WrongCRCException){
    char      subData[dataLength];
    memset(subData,  0, dataLength*sizeof(char));
    InputFile->read(subData, sizeof(subData));
    trgInit->trgInitData        = new TArrayC(dataLength, subData);
}

