/** @file
 * $Source: /afs/ba.infn.it/user/pamela/src/CVS/yoda/event/PscuHeader.h,v $
 * $Id: PscuHeader.h,v 6.1 2006/09/29 10:19:13 mocchiut Exp $
 * $Author: mocchiut $
 * 
 * Header file for the PscuHeader class.
 */
#ifndef PSCU_HEADER_H
#define PSCU_HEADER_H

#include "Exception.h"
#include "SubPacket.h"

namespace pamela {
  /**
   * Class containing the PSCU header and trailer information.
   */
  class PscuHeader: public pamela::SubPacket {

  private:

  public:
    unsigned int Header;  /**< Packet type header (must be 0xFAFEDE) */
    UINT8  PacketId1; /**< Packet type first  byte */
    UINT8  PacketId2; /**< Packet type second byte */
    UINT32 Counter; /**< PSCU event counter */
    UINT32 OrbitalTime; /**< Raw Orbital time */
    UINT32 PacketLenght;
    UINT8  CRC; /**< PSCU Header Checksum  */ //!

    /* This parameter represent the offset of the header relative to the begin
     * of the file it has been extracted. It's purpose is to
     * check whenever the CPU (for error) store the same packet more than one time.
     * It's not clear if it will be mantained or not in the definitive release.
    */
    UINT32 FileOffset; 
    
    PscuHeader();
    virtual ~PscuHeader(){};
    const pamela::PacketType* GetPacketType(void) const throw(UnidentifiedPacketException);
    /** Get the Header. */
    int GetHeader(void) const { return Header; } 
    /** Get packet id 1. */
    unsigned char GetPacketId1(void) const { return PacketId1; } 
    /** Get packet id 2. */
    unsigned char GetPacketId2(void) const { return PacketId2; } 
    /** Get the PSCU event counter. */
    int GetCounter(void) const { return Counter; } 
    /** Get the orbital time. */
    int GetOrbitalTime(void) const { return OrbitalTime; } 
    /** Get the header CRC. */
    unsigned char GetCRC(void) const { return CRC; }
   /** Get the packet length for this packet. */
    int GetPacketLenght(void) const { return PacketLenght; }
   /** Get the offset of the packet relative to the begin of the raw file. */
    int GetFileOffset(void) const { return FileOffset; }
 
    /** Set the orbital time. Intended to use by the raw reader. */
    void SetHeader(int var) { Header  = var; }
    /** Set the packet id. Intended to use by the raw reader. */
    void SetPacketId(short var1, short var2) { PacketId1 = var1; PacketId2 = var2; }
     /** Set the counter. Intended to use by the raw reader. */
    void SetCounter(int var) { Counter = var; }
    /** Set the orbital time. Intended to use by the raw reader. */
    void SetOrbitalTime(int var) { OrbitalTime = var; }
    /** Set the packet length. Intended to use by the raw reader. */
    void SetPacketLenght(int var) { PacketLenght = var; }
    /** Set the packet length. Intended to use by the raw reader. */
    void SetCRC(short var) { CRC = var; }
    /** Get the offset of the packet relative to the begin of the raw file. */
    int SetFileOffset(unsigned long int var) { if ( var > numeric_limits<unsigned int>::max() ) var -= numeric_limits<unsigned int>::max() ;FileOffset = (unsigned int)var; return(0); }

    const char* Print(){
        oss.str("");
        oss <<  "\n Packet Counter          : "  <<  hex << Counter
            <<  "\n Id1 - Id2               : "  <<  hex << (UINT16)PacketId1 <<  " - " << hex << (UINT16)PacketId2
            <<  "\n Orbital Time            : "  <<  hex << OrbitalTime
            <<  "\n Lenght                  : "  <<  hex << PacketLenght
            <<  "\n CRC                     : "  <<  hex << (UINT16)CRC
            <<  "\n Header Start Position   : "  <<  hex << FileOffset;
        return oss.str().c_str(); 
    }

  static const char* Print(char* buff){
  static stringstream out;
    out.str("");
    out <<  "\n Packet Counter          : "  <<  hex << (((UINT32)buff[5]<<16)&0x00FF0000) + (((UINT32)buff[6]<<8)&0x0000FF00) + (((UINT32)buff[7])&0x000000FF)
        <<  "\n Id1 - Id2               : "  <<  hex << (UINT16)buff[3] <<  " - " << hex << (UINT16)buff[4]
        <<  "\n Orbital Time            : "  <<  hex << (((UINT32)buff[8]<<24)&0xFF000000) + (((UINT32)buff[9]<<16)&0x00FF0000) +  (((UINT32)buff[10]<<8)&0x0000FF00) + (((UINT32)buff[11])&0x000000FF)
        <<  "\n Lenght                  : "  <<  hex << (((UINT32)buff[12]<<16)&0x00FF0000) +  (((UINT32)buff[13]<<8)&0x0000FF00) + (((UINT32)buff[14])&0x000000FF)
        <<  "\n CRC                     : "  <<  hex << (UINT16)buff[15];
    return out.str().c_str(); 
  }
    
    ClassDef(PscuHeader, 1)
  };
}

#endif /* PSCU_HEADER_H */
