/** @file
 * $Author: kusanagi $
 * $Date: 2006/02/07 10:43:06 $
 * $Revision: 5.3 $
 * 
 * Implementation of the TofAlarmReader class.
 */

#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.TofAlarmReader"));

/**
 * Constructor. 
 */
TofAlarmReader::TofAlarmReader(void): 
  TechmodelAlgorithm(PacketType::TofAlarm, "TechmodelTofAlarmReader") { 
  logger->debug(_T("Constructor"));
  tofAlarm = new TofAlarmEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string TofAlarmReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/TofAlarmReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void TofAlarmReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &tofAlarm, tofAlarm->Class());
  logger->debug(_T("Initialize"));
}

/**
 * Unpack the TofAlarm event from an input file.
 * The CPU does not add any CRC control at the packet end.
 * @param EventNumber 
 * @param dataLength 
 */
void TofAlarmReader::RunEvent(int EventNumber, long int dataLength) throw (WrongCRCException){
    char      subData[dataLength];
    InputFile->read(subData, sizeof(subData));
    tofAlarm->tofAlarmData        = new TArrayC(dataLength, subData);
}

