/** @file
 * $Author: kusanagi $
 * $Date: 2006/05/30 19:10:01 $
 * $Revision: 6.1 $
 * 
 * Implementation of the Ac2AlarmReader class.
 */

#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.Ac2AlarmReader"));

/**
 * Constructor. 
 */
Ac2AlarmReader::Ac2AlarmReader(void): 
  TechmodelAlgorithm(PacketType::Ac2Alarm, "TechmodelAc2AlarmReader") { 
  logger->debug(_T("Constructor"));
  acAlarm = new Ac2AlarmEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string Ac2AlarmReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/ac2AlarmReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void Ac2AlarmReader::Init(PamelaRun *run) {
  SetInputStream(run);
  run->WriteSubPacket(this, &acAlarm, acAlarm->Class());
  logger->debug(_T("Initialize"));
}

/**
 * Unpack the Ac2Alarm event from an input file.
 */
void Ac2AlarmReader::RunEvent(int EventNumber, long int dataLength) throw (WrongCRCException){

char     subData[dataLength];
InputFile->read(subData, sizeof(unsigned char)*dataLength);
acAlarm->ac2AlarmData        = new TArrayC(dataLength, subData);

}

