/** @file
 * $Source: /home/cvsmanager/yoda/techmodel/TechmodelPamelaRun.cpp,v $
 * $Id: TechmodelPamelaRun.cpp,v 5.1 2006/02/04 12:37:45 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Implementation of the TechmodelPamelaRun class.
 */


#include <log4cxx/logger.h>
#include "TechmodelPamelaRun.h"

using namespace pamela;
using namespace pamela::techmodel;


static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.TechmodelPamelaRun"));

/**
 * Create a new Pamela run structure to write the data from the 
 * techmodel data files into the ROOT TTrees.
 * @param run Run number
 */
TechmodelPamelaRun::TechmodelPamelaRun(std::string fileName, std::string path, bool multiFile, short compression) :
  PamelaRun(fileName, path, multiFile, compression) {
  InputFile = new ifstream(fileName.c_str(), std::ios::binary); //inserito ios::binary maurizio 01/03/2004
  if (!*InputFile){
    std::stringstream oss;
    oss.str("");
    oss << "Cannot open file " << fileName;
    logger->error(oss.str().c_str());
    throw std::exception();
  }
  else
    {
  // :TODO: InputFile should be a dervived class for cross-checking of 
  // packet lengths.      
    }

}





