/** @file
 * $Author: kusanagi $
 * $Date: 2006/02/07 10:43:06 $
 * $Revision: 5.3 $
 * 
 * Implementation of the CalInitReader class.
 */

#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.CalInitReader"));

/**
 * Constructor. 
 */
CalInitReader::CalInitReader(void): 
  TechmodelAlgorithm(PacketType::CalInit, "TechmodelCalInitReader") { 
  logger->debug(_T("Constructor"));
  calInit = new CalInitEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string CalInitReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/CalInitReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void CalInitReader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &calInit, calInit->Class());
}

/**
 * Unpack the CalInit event from an input file.
 * The CPU does not add any CRC control at the packet end.
 * @param EventNumber 
 * @param dataLength 
 */
void CalInitReader::RunEvent(int EventNumber, long int dataLength) throw (WrongCRCException){
    char      subData[dataLength];
    InputFile->read(subData, sizeof(subData));
    calInit->calInitData        = new TArrayC(dataLength, subData);
}

