/** @file
 * $Author: kusanagi $
 * $Date: 2006/02/07 10:43:06 $
 * $Revision: 5.3 $
 * 
 * Implementation of the ForcedFECmdReader class.
 */

#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.ForcedFECmdReader"));

/**
 * Constructor. 
 */
ForcedFECmdReader::ForcedFECmdReader(void): 
  TechmodelAlgorithm(PacketType::ForcedFECmd, "TechmodelForcedFECmdReader") { 
  logger->debug(_T("Constructor"));
  forcedFECmd = new ForcedFECmdEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string ForcedFECmdReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/ForcedFECmdReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void ForcedFECmdReader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &forcedFECmd, forcedFECmd->Class());
}

/**
 * Unpack the ForcedFECmd event from an input file.
 * The CPU does not add any CRC control at the packet end.
 * @param EventNumber 
 * @param dataLength 
 */
void ForcedFECmdReader::RunEvent(int EventNumber, long int dataLength) throw (WrongCRCException){
    char      subData[dataLength];
    InputFile->read(subData, sizeof(subData));
    forcedFECmd->forcedFECmdData        = new TArrayC(dataLength, subData);
}

