/** @file
 * $Source: /home/cvsmanager/yoda/techmodel/CalibTofReader.cpp,v $
 * $Id: CalibTofReader.cpp,v 6.1 2006/05/30 19:10:01 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Implementation of the LogReader class.
* ToBeDone:
* Control the CRC for the entire data Packet not just for single records
 */


#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.CalibTofReader"));

/**
 * Constructor. 
 */
CalibTofReader::CalibTofReader(void): 
  TechmodelAlgorithm(PacketType::Log, "TechmodelCalibTofReader") { 
  logger->debug(_T("Constructor"));
  calibTof = new CalibTofEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string CalibTofReader::GetVersionInfo(void) const {
  return 
    "$Header: /home/cvsmanager/yoda/techmodel/CalibTofReader.cpp,v 6.1 2006/05/30 19:10:01 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void CalibTofReader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &calibTof, calibTof->Class());
}

/**
 * Unpack the CalibTof event from an input file.
 */
void CalibTofReader::RunEvent(int EventNumber, long int dataLength) throw (Exception){
    char      subData[dataLength];
    InputFile->read(subData, sizeof(subData));
    calibTof->calibTofData        = new TArrayC(dataLength, subData);
}

