/** @file
 * $Author: kusanagi $
 * $Date: 2006/02/04 12:37:44 $
 * $Revision: 5.1 $
 * 
 * Implementation of the CalibHeaderReader class.
 */ 

#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.CalibHeaderReader"));

/**
 * Constructor. 
 */
CalibHeaderReader::CalibHeaderReader(void): 
  TechmodelAlgorithm(PacketType::CalibHeader, "TechmodelCalibHeaderReader") { 
  logger->debug(_T("Constructor"));
  calibHeader = new CalibHeaderEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string CalibHeaderReader::GetVersionInfo(void) const {
  return 
    "$Header: /home/cvsmanager/yoda/techmodel/CalibHeaderReader.cpp,v 5.1 2006/02/04 12:37:44 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void CalibHeaderReader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &calibHeader, calibHeader->Class());
}

/**
 * Unpack the CalibHeader event from an input file.
 */
void CalibHeaderReader::RunEvent(int EventNumber, long int dataLength) throw (WrongCRCException){
    char      subData[dataLength];
    UINT16    subCRC;      //calculated CRC of the data
    UINT16    readCRC;     //CRC read from the end of the subpacket
    long int  length = dataLength - 2; //the block of data

    InputFile->read(subData, sizeof(subData));
    subCRC  = CM_Compute_CRC16(0, (UINT8*)subData, length);
    readCRC = (((UINT16)(subData[dataLength - 2]<<8))&0xFF00) + (((UINT16)subData[dataLength - 1])&0x00FF);

    if (subCRC != readCRC) throw WrongCRCException(" Wrong CRC for CalibHeader Packet ");
}

