/** @file
 * $Source: /home/cvsmanager/yoda/techmodel/physics/AnticounterReader.cpp,v $
 * $Id: AnticounterReader.cpp,v 4.4 2005/05/28 10:44:13 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Implementation of the AnticounterReader class.
 */

#include <string>
#include <log4cxx/logger.h>
#include "AnticounterReader.h"

extern "C" {
    #include "../forroutines/anticounter/AC.h"
    extern int ACphysics(int, unsigned char[] , struct physicsstruct*);
}

using namespace pamela;
using namespace pamela::anticounter;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.anticounter.AnticounterReader"));

/**
 * Constructor. 
 */
AnticounterReader::AnticounterReader(void): 
  TechmodelAlgorithm(PacketType::Physics, "TechmodelAnticounterReader") { 
  logger->debug(_T("Constructor"));
  anticounter = new AnticounterEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string AnticounterReader::GetVersionInfo(void) const {
  return 
    "$Header: /home/cvsmanager/yoda/techmodel/physics/AnticounterReader.cpp,v 4.4 2005/05/28 10:44:13 kusanagi Exp $";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void AnticounterReader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &anticounter, anticounter->Class());
}

/**
 * Unpack the anticounter event from an input file.
 */
void AnticounterReader::RunEvent(int EventNumber) {
  
}

/**
 * Unpack the Anticounter data event from the physical packet.
 */
void AnticounterReader::RunEvent(int EventNumber, const char subData[], long int length) {
    std::stringstream oss;
    char *data = new char[length];
    memcpy(data, subData, length);
    struct physicsstruct output[2] = {0};
    
    
    
    //Call to the routine that unpack anitocounter events
    //anticounter->ERROR = ACphysics(length, (unsigned char*) data, &(*output));
    anticounter->unpackError = ACphysics(length, (unsigned char*) data, output);
    
    //if (ERROR != 0) {
        char *errmsg;
        switch (anticounter->unpackError){
            case 0xFF: errmsg = "data (physics or calibration) from both cards found";
            break;
            case 0xF0: errmsg = "only data from main card found";
            break;
            case 0x0F: errmsg = "only data from extra card found";
            break;
            case 0x00: errmsg = "no data found";
            break;
            default: errmsg = "ANTICOUNTER ERRROR CODE UNIDENTIFIED";
        }
        oss.str("");
        oss << "Fortran77 function tofunpack: " <<  errmsg;
        logger->warn(oss.str().c_str());
    //}

    for(int i = 0; i<2; i++){
        memcpy(anticounter->header[i], output[i].header, sizeof(anticounter->header[i]));
        anticounter->status[i] = output[i].status;
        anticounter->hitmap[i] = output[i].hitmap;
        memcpy(anticounter->regist[i],     output[i].regist,    sizeof(output[i].regist));
        memcpy(anticounter->shift[i],      output[i].shift,     sizeof(output[i].shift));
        memcpy(anticounter->counters[i],   output[i].counters,  sizeof(output[i].counters));
        memcpy(anticounter->coinc[i],      output[i].coinc,     sizeof(output[i].coinc));
        anticounter->trigg[i] = output[i].trigg;
        memcpy(anticounter->clock[i],      output[i].clock,     sizeof(output[i].clock));
        memcpy(anticounter->temp[i],       output[i].temp,      sizeof(output[i].temp));
        memcpy(anticounter->DAC[i],        output[i].DAC,       sizeof(output[i].DAC));
        anticounter->CRC[i]         = output[i].CRC;
        anticounter->CRCcheck[i]    = output[i].CRCcheck;
    }

    //}
    delete [] data;
}
