
// Implementation of the InitHeaderReader class.
 

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cxx/logger.h>
extern "C" {
#include <sys/time.h>
#include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

#include "event/InitHeaderEvent.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.InitHeaderReader"));

/**
 * Constructor. 
 */
InitHeaderReader::InitHeaderReader(void): 
  TechmodelAlgorithm(PacketType::InitHeader, "TechmodelInitHeaderReader") { 
  logger->debug(_T("Constructor"));
  initHeader = new InitHeaderEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string InitHeaderReader::GetVersionInfo(void) const {
  return 
    "$Header: /home/cvsmanager/yoda/techmodel/InitHeaderReader.cpp,v 4.4 2005/05/28 10:44:11 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void InitHeaderReader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &initHeader, initHeader->Class());
}

/**
 * Unpack the InitHeader event from an input file.
 */
void InitHeaderReader::RunEvent(int EventNumber, long int length) throw (WrongCRCException){
    
    
    
}

