/** @file
 * $Source: /home/cvsmanager/yoda/event/EventHeader.cpp,v $
 * $Id: EventHeader.cpp,v 4.4 2005/05/28 10:44:09 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Implementation of the EventHeader class.
 */
#include "EventHeader.h"

using namespace pamela;

/** 
 * Create a new event header object which belongs to all packet types
 * @param run Run number
 */ 
EventHeader::EventHeader(int run): 
  SubPacket("Header"), Counter(run) {
}

/** 
 * Create a new event header object.
 * @param type Packet type the header event belongs to.
 */ 
EventHeader::EventHeader(const PacketType* t): 
  SubPacket("Header", t), Counter(0) {
}



/**
 * Destroy the event header object.
 */
EventHeader::~EventHeader() { }

ClassImp(EventHeader)
