
// Implementation of the S4InitReader class.
 

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cxx/logger.h>
extern "C" {
    #include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"


using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.S4InitReader"));

/**
 * Constructor. 
 */
S4InitReader::S4InitReader(void): 
  TechmodelAlgorithm(PacketType::S4Init, "S4InitReader") { 
  logger->debug(_T("Constructor"));
  s4Init = new S4InitEvent;
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string S4InitReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/S4InitReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void S4InitReader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &s4Init, s4Init->Class());
}

/**
 * Unpack the S4Init event from an input file.
 */
void S4InitReader::RunEvent(int EventNumber, long int length) throw (WrongCRCException){

}

