/** @file
 * $Author: kusanagi $
 * $Date: 2005/05/28 10:44:13 $
 * $Revision: 4.4 $
 * 
 * Header file for the algorithms used to read the techmodel calorimeter events.
 */

#ifndef CALORIMETER_READER_H
#define CALORIMETER_READER_H

#include "techmodel/TechmodelAlgorithm.h"
#include "event/PamelaRun.h"
#include "event/physics/calorimeter/CalorimeterEvent.h"


namespace pamela {
  namespace calorimeter {
    /**
     * Algorithm to read fligthmodel calorimeter physics events.
     */
    class CalorimeterReader: public pamela::techmodel::TechmodelAlgorithm {
    private:
      /**
       * The physics event that is created in this algorithm.
       */
      CalorimeterEvent *calorimeter;
    public:
      CalorimeterReader(void);
      virtual void Init(PamelaRun *);
      virtual void RunEvent(int);
      virtual void RunEvent(int, const char[] , long int);
      virtual std::string GetVersionInfo(void) const;
    };
  }
}

#endif /* CALORIMETER_READER_H */
