/** @file
 * $Source: /home/cvsmanager/yoda/techmodel/Calib1_Ac1Reader.cpp,v $
 * $Id: Calib1_Ac1Reader.cpp,v 4.4 2005/05/28 10:44:10 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Implementation of the Calib1_Ac1Reader class.
 */

#include <string>
#include <log4cxx/logger.h>
#include <fstream>
#include "stdio.h"
extern "C" {
    #include "CRC.h"
    #include "forroutines/anticounter/AC.h"
    extern int ACcalib(int length, unsigned char* calibpointer, struct calibstruct* calibpointer);
}

#include "ReaderAlgorithms.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.Calib1_Ac1Reader"));

/**
 * Constructor. 
 */
Calib1_Ac1Reader::Calib1_Ac1Reader(void): 
  TechmodelAlgorithm(PacketType::Calib1_Ac1, "Calib1_Ac1") { 
  logger->debug(_T("Constructor"));
  calib1_Ac1 = new Calib1_Ac1Event();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string Calib1_Ac1Reader::GetVersionInfo(void) const {
  return "$Header: /home/cvsmanager/yoda/techmodel/Calib1_Ac1Reader.cpp,v 4.4 2005/05/28 10:44:10 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void Calib1_Ac1Reader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &calib1_Ac1, calib1_Ac1->Class());
}

/**
 * Unpack the Calib1_Ac1Reader event from an input file.
 */
void Calib1_Ac1Reader::RunEvent(int EventNumber, long int dataLength) throw (Exception){
/*

*/  
  //delete [] subData;
}

