/****************************************************************************
 *  F i l e   D a t a                                                        
 *  $Id: HB_HKBuffer_INFN.h,v 4.4 2005/05/28 10:44:09 kusanagi Exp $
 *  $Revision: 4.4 $ 
 *  $Date: 2005/05/28 10:44:09 $     
 *  $RCSfile: HB_HKBuffer_INFN.h,v $ 
 *                                                                           
 ****************************************************************************
 *  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
 *                                                                           
 *  $Author: kusanagi $                                                                   
 *               :                                                           
 ****************************************************************************
 *                                                                           
 *****************************************************************************/

#ifndef _HB_HKBUFFER_INFN_H
#define _HB_HKBUFFER_INFN_H


/*============================= Include File ================================*/

#ifndef I386
#include <src/SRAMManager/SRAMPageManager/SM_SRAMPageManager_p.h>
#include <src/BasicSW/RTEMSInterface/OS_rtems_p.h>
#include <src/MCMDManager/MCMDArea/MA_MCMDArea_p.h>
#include <src/INFN/OS_rtems_INFN_p.h>
#endif // I386

#ifdef OLDANALISI
#include <src/INFN/CM_Common_INFN.h>
#include <src/INFN/DAQ_IDAQ_INFN.h>
#endif // OLDANALISI

#define UINT32 unsigned int 
/*============================ Global define ================================*/

#define HB_SKETCHSIZE  SM_SKETCHSIZE


#define HB_BUF_TMTC_SIZE (20*1024)
#define HB_BUF_MCMD_SIZE (20*1024)
#define HB_BUF_LOG_SIZE  ( 6*1024)
#define HB_BUF_VARDUMP_SIZE  PRH_TOTAL_VAR_SIZE
#define HB_BUF_ARRDUMP_SIZE  PRH_TOTAL_ARR_SIZE
#define HB_BUF_TABDUMP_SIZE  PRH_TOTAL_TAB_SIZE
#define HB_BUF_RUNHEADER_SIZE (1*1024)
#define HB_BUF_RUNTRAILER_SIZE (1*1024)
#define HB_BUF_SKETCHBOARD_SIZE (64*1024)
#define HB_BUF_USERDATA_SIZE (64*1024)

/* number of user defined buffer */
#define HB_USERDATA_NO 4

#define HB_HEADER_1 0xFA
#define HB_HEADER_2 0xFE
#define HB_HEADER_3 0xDE

#define HB_PKTTYPE_PHYS_PKT   0x10 /* Experiment  Event Packet */
#define HB_PKTTYPE_FORCED_PKT 0x11 /* Force Idaq Cmd-queue Event Packet */
#define HB_PKTTYPE_CALIB_TRK  0x12 /* Tracker Calibration Event Packet */
#define HB_PKTTYPE_CALIB_TRG  0x13 /* Trigger Calibration Event Packet */
#define HB_PKTTYPE_CALIB_CAL  0x14 /* Calorimeter Calibration Event Packet */
#define HB_PKTTYPE_CALIB_TRD  0x15 /* TRD Calibration Event Packet */
#define HB_PKTTYPE_CALIB_TOF  0x16 /* TOF Calibration Event Packet */
#define HB_PKTTYPE_CALIB_S4   0x17 /* S4 Calibration Event Packet */
#define HB_PKTTYPE_RUNHEADER  0x20 /* The starting of a Run */
#define HB_PKTTYPE_RUNTRAILER 0x21 /* The ending of a Run */
#define HB_PKTTYPE_ALARM      0x30 /* TBD */
#define HB_PKTTYPE_KHB        0x40 /* TBD */
#define HB_PKTTYPE_LOG        0x50 /* Log block */
#define HB_PKTTYPE_VARDUMP    0x51 /* ParamDump block var*/
#define HB_PKTTYPE_ARRDUMP    0x52 /* ParamDump block arr*/
#define HB_PKTTYPE_TABDUMP    0x53 /* ParamDump block tab*/
#define HB_PKTTYPE_TMTC       0x54 /* TMTC block */
#define HB_PKTTYPE_MCMD       0x55 /* MCMD block */

/*============================== global types  ==============================*/




/*****************************************************************************/
/*=========================== Structure define ==============================*/

typedef struct {
  // TBD:
  UINT32 info1;
  UINT32 info2;
} HB_RUN_HEADER_INFO;

typedef struct {
  // TBD:
  UINT32 info1;
  UINT32 info2;
} HB_RUN_TRAILER_INFO;

/*****************************************************************************/
/*============================ Enumerate define =============================*/
typedef enum {
  HB_NULL,
  HB_TMTC,
  HB_MCMD,
  HB_LOG,
  HB_VARDUMP,
  HB_ARRDUMP,
  HB_TABDUMP,
  HB_SKETCHBOARD,   
  HB_RUNHEADER,
  HB_RUNTRAILER,
  HB_USERDATA0,
  HB_USERDATA1,
  HB_USERDATA2,
  HB_USERDATA3,
  HB_MAX
} HB_BUF;

/*===========================================================================*/



#ifndef I386
static status_code HB_SemP();
static status_code HB_SemV();
status_code HB_Init();
static status_code HB_InitBuf_NoLock(HB_BUF bufid);
status_code HB_InitBuf(HB_BUF bufid);
unsigned int HB_SpaceLeft(HB_BUF bufid);
status_code HB_Store(HB_BUF bufid,unsigned short int len,void *dataptr,TI_TIME obt);
status_code HB_WriteToPIF();
status_code HB_SaveBuffer2MM(DAQ_CMD_BUF *buffer, FS_FILEID id,UINT32 timeout);

status_code HB_SaveHBBuffer2MM(HB_BUF bufid,UINT32 timeout);
status_code HB_SetRunHeaderInfo( /* params TBD */ );
status_code HB_SetRunTrailerInfo( /* params TBD */ );
#endif // I386



#endif // _HB_HKBUFFER_INFN_H


