/** @file
 * $Source: /home/cvsmanager/yoda/event/Filter.h,v $
 * $Id: Filter.h,v 4.4 2005/05/28 10:44:09 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Header file for the Filter class.
 */
#ifndef FILTER_H
#define FILTER_H

#include <string>
#include "event/PacketType.h"
#include <TObject.h> 
using namespace std;
using namespace pamela;

namespace pamela {
    class PacketType;
  /**
   * Abstract base class for filtering algorithms. You need to deviate
   * from this class and overwrite the functions Init(), check() and
   * Finish(), if necessary. For logging purposes, you also need to write
   * the functions GetName() and GetVersionInfo().
   */
  class Filter: public TObject {

  public:
    Filter(); 
    /**
     * Initialize the filter. Default: Do nothing. 
     */
      virtual void Init(void) {}

    /**
     * Define the filter property. Default: Do nothing. 
     */
      virtual bool CheckPacket(pamela::PacketType *) = 0;
    /**
     * Get a string with the version info of the filter. 
     * Must be overwritten. 
     */
    virtual std::string GetVersionInfo(void) const = 0;
    ClassDef(Filter, 1)
  };

}

#endif /* FILTER_H */
