#ifndef CALIBTRK2_EVENT_H
#define CALIBTRK2_EVENT_H

#include "SubPacket.h"

namespace pamela {
  /**
   * CalibTrk2 data Wrapper.
   *
   * The pamela::CalibTrk2 packet is the answer to a calibration session of half-sight of Tracker.
   * The pedestal for each ladder is calculated dividing the 1024 strips composing each ladder in 
   * blocks of 128 strips each. The mean of the sum of the blocks divided by 4 give the ped_lX value
   * for each ladder.
   */
  class CalibTrk2Event: public pamela::SubPacket {
  private:
    
  public:
    CalibTrk2Event(void);

    /**
     * The acquisition mode of the Tracker; each element concerns a different plane.
     */   
    int   DAQmode[6];

    /**
     * The DSP number of the Tracker; each element concerns a different plane.
     * If the element is 0 the DSP is not working.
     */   
    int   DSPnumber[6];

    /**
     * The Calibration number; each element concerns a different plane.
     */
    int   calibnumber[6];

    /**
     * Counter of event?s number used for calibration; each element concerns a different plane.
     */
    int   ncalib_event[6];

    /**
     * Pedestal values for Ladder1; each element concerns a different plane.
     */
    int   ped_l1[6];

    /**
     * Pedestal values for Ladder2; each element concerns a different plane.
     */
    int   ped_l2[6];

    /**
     * Pedestal values for Ladder3; each element concerns a different plane.
     */
    int   ped_l3[6];

    /**
     * The Sigma values for the ped_l1 values; each element concerns a different plane.
     */    
    int   sig_l1[6];

    /**
     * The Sigma values for the ped_l2 values; each element concerns a different plane.
     */    
    int   sig_l2[6];

    /**
     * The Sigma values for the ped_l3 values; each element concerns a different plane.
     */    
    int   sig_l3[6];

    /**
     * The number of bad strips for the ped_l1 values; each element concerns a different plane.
     */        
    int   nbad_l1[6];

    /**
     * The number of bad strips for the ped_l2 values; each element concerns a different plane.
     */        
    int   nbad_l2[6];

    /**
     * The number of bad strips for the ped_l3 values; each element concerns a different plane.
     */        
    int   nbad_l3[6];

   /**
     * Calibration validity check; each element concerns a different plane.
     * Description:               <BR>
     * 1: The calibration is bad. <BR>
     * 0: The calibration is ok.  <BR>
     */        
    int   cal_flag[6];

    /**
     * The value of the pedestal for each strip (3072 strips in 6 planes).  
     */            
    float DSPped_par[6][3072];

    /**
     * The value of the Sigma for each strip (3072 strips in 6 planes).  
     */        
    float DSPsig_par[6][3072];

    /**
     * Identify which strip is bad (3072 strips in 6 planes).  
     */        
    int   DSPbad_par[6][3072];
    UINT8 unpackError;
    ClassDef(CalibTrk2Event, 3)
  };
}

#endif /* CALIBTRK2_EVENT_H */

