
// Implementation of the CalibTrkBothReader class.
 

#define UINT unsigned int
#define BYTE  unsigned char
#include <string>
#include <log4cxx/logger.h>
extern "C" {
#include <sys/time.h>
#include "CRC.h"
}

#include <fstream>
#include "stdio.h"
#include "ReaderAlgorithms.h"

#include "event/CalibTrkBothEvent.h"

using namespace pamela;
using namespace pamela::techmodel;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.CalibTrkBothReader"));

/**
 * Constructor. 
 */
CalibTrkBothReader::CalibTrkBothReader(void): 
  TechmodelAlgorithm(PacketType::CalibTrkBoth, "TechmodelCalibTrkBothReader") { 
  logger->debug(_T("Constructor"));
  calibTrkBoth = new CalibTrkBothEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string CalibTrkBothReader::GetVersionInfo(void) const {
  return 
    "$Header: /home/cvsmanager/yoda/techmodel/CalibTrkBothReader.cpp,v 3.0 2005/03/04 15:54:11 kusanagi Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void CalibTrkBothReader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &calibTrkBoth, calibTrkBoth->Class());
}

/**
 * Unpack the CalibTrkBoth event from an input file.
 */
void CalibTrkBothReader::RunEvent(int EventNumber, long int length) throw (Exception){
    
    
}

