/** @file
 * $Source: /home/cvsmanager/yoda/techmodel/physics/TriggerReader.cpp,v $
 * $Id: TriggerReader.cpp,v 3.1 2005/03/06 04:29:24 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Implementation of the CalorimeterReader class.
 */


#include <iostream>
#include <string>
#include <log4cxx/logger.h>
#include "TriggerReader.h"

extern "C" {
  

  extern struct {
    int         evcount;
    int         pmtpl[3];
    int         trigrate[6];
    int         dltime[2];
    int         s4calcount[2]; 
    int         pmtcount1[24];
    int         pmtcount2[24];
    int         patternbusy[3];
    int         patterntrig[6];
    int         trigconf;
  } trig_; 

  void triggerunpack_(unsigned char[], long int*, int*);

    //Struct per il passaggio di dati da e verso la chiamata fortran
}

using namespace pamela;
using namespace pamela::trigger;

static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.trigger.TriggerReader"));
 
/**
 * Constructor.     
 */
TriggerReader::TriggerReader(void): 
  TechmodelAlgorithm(PacketType::Physics, "TechmodelTriggerReader") { 
  logger->debug(_T("Construnctor"));
  trigger = new TriggerEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string TriggerReader::GetVersionInfo(void) const {
  return 
    "$Header: /home/cvsmanager/yoda/techmodel/physics/TriggerReader.cpp,v 3.1 2005/03/06 04:29:24 kusanagi Exp $";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void TriggerReader::Init(PamelaRun *run) {
  logger->debug(_T("Initialize"));
  SetInputStream(run);
  run->WriteSubPacket(this, &trigger, trigger->Class());
}

/**
 * Unpack the trigger event from an input file.
 */
void TriggerReader::RunEvent(int EventNumber) {
  
}

/**
 * Unpack the Trigger data event from the physical packet.
 */
void TriggerReader::RunEvent(int EventNumber, const char subData[], long int length) {
    std::stringstream oss;       
    char *data = new char[length];
    memcpy(data, subData, length);
    int  ERROR = 0;
    
    /*unsigned short convdata[length];
    for (int i = 0; i<length; i++){
        convdata[i] = (unsigned short)((unsigned char)subData[i]&0xFF);
    }*/

    
    //Call to the routine that unpack trigger events
    triggerunpack_((unsigned char*)data, &length, &ERROR);
    

    if (ERROR != 0) {
        char *errmsg;
        switch (ERROR){
            case 1: errmsg = "GENERIC TRIGGER ERROR";
            break;
            default: errmsg = "TRIGGER ERRROR CODE UNIDENTIFIED";
        }
        oss.str("");
        oss << "Fortran77 function triggerunpack: " <<  errmsg;
        logger->warn(oss.str().c_str());
    }
    //  In case of "ERROR != 0" the calunpack will take care to set all 
    //  parameters to zero
    //} else {

    trigger->evcount   = trig_.evcount;
    memcpy(trigger->pmtpl, trig_.pmtpl, sizeof(trigger->pmtpl));
    memcpy(trigger->trigrate, trig_.trigrate, sizeof(trigger->trigrate));
    memcpy(trigger->dltime, trig_.dltime, sizeof(trigger->dltime));
    memcpy(trigger->s4calcount, trig_.s4calcount, sizeof(trigger->s4calcount));
    memcpy(trigger->pmtcount1, trig_.pmtcount1, sizeof(trigger->pmtcount1));
    memcpy(trigger->pmtcount2, trig_.pmtcount2, sizeof(trigger->pmtcount2));
    memcpy(trigger->patternbusy, trig_.patternbusy, sizeof(trigger->patternbusy));
    memcpy(trigger->patterntrig, trig_.patterntrig, sizeof(trigger->patterntrig));
    trigger->trigconf = trig_.trigconf;
 
    delete [] data;
}
